/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments;

import java.util.Collection;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.log.Logger;
import kickass.nonasm.tools.StringUtil;
import kickass.nonasm.tools.collections.OrderedMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.sideeffect.SEIncreaseMemoryPosition;
import kickass.pass.sideeffect.SESetMemoryPosition;
import kickass.pass.sideeffect.SESwitchSegment;
import kickass.setup.configuration.parameters.KickAssemblerParameters;
import kickass.state.EvaluationState;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentMemoryBlock;
import kickass.state.segments.resolvers.ConstantStartResolver;
import kickass.state.segments.resolvers.IStartResolver;
import kickass.state.segments.resolvers.SoftblockStartResolver;

public class SegmentManager {
    public static final IStartResolver defaultStartResolver = new ConstantStartResolver(8192, null);
    private EvaluationState state;
    private boolean isPseudoPcMode = false;
    public int pseudoPcPosition = -1;
    public Segment defaultSegment;
    public boolean allSegmentsAreRegistered = false;
    private Segment currentSegment;
    private Map<String, Segment> segments = new OrderedMap<String, Segment>();

    public SegmentManager(EvaluationState evaluationState) {
        this.state = evaluationState;
        this.defaultSegment = new Segment("Default", null);
        this.defaultSegment.setIsDefault(true);
        this.defaultSegment.setFillByte(evaluationState.parameters.fillByte);
        this.segments.put(this.defaultSegment.getName(), this.defaultSegment);
    }

    public Segment getSegment(String string) {
        return this.segments.get(string);
    }

    public void addSegment(Segment segment) {
        if (this.segments.containsKey(segment.getName())) {
            throw new AsmErrorException("Already have a segment by the name of: " + segment.getName());
        }
        this.segments.put(segment.getName(), segment);
    }

    public void switchToSegment(Segment segment) {
        if (this.isPseudoPcMode) {
            throw new AsmErrorException("Can't switch segment while inside a pseudopc directive");
        }
        this.switchToSegmentWithoutSideEffect(segment);
        this.state.sideeffectMgr.addSideEffect(new SESwitchSegment(segment));
    }

    public void switchToSegmentWithoutSideEffect(Segment segment) {
        this.currentSegment = segment;
    }

    public Segment getCurrentSegment() {
        return this.currentSegment;
    }

    public Collection<Segment> getSegments() {
        return this.segments.values();
    }

    public int getMemoryPosition() {
        if (this.isPseudoPcMode) {
            return this.pseudoPcPosition;
        }
        return this.currentSegment.getMemoryPosition();
    }

    public void invalidateMemoryPosition() {
        this.currentSegment.invalidateMemoryPos();
        this.pseudoPcPosition = -1;
        this.state.sideeffectMgr.setErrorDuringFunctionEvaluation(true);
    }

    public SegmentMemoryBlock startSoftMemoryBlock(String string, SourceRange sourceRange) {
        if (this.isPseudoPcMode) {
            throw new AsmErrorException("You can't start a new memoryblock in pseudo pc mode", sourceRange);
        }
        SegmentMemoryBlock segmentMemoryBlock = new SegmentMemoryBlock(string, this.currentSegment.isVirtual());
        segmentMemoryBlock.setStartResolver(new SoftblockStartResolver(this.currentSegment.getCurrentMemoryBlock()));
        this.currentSegment.getCurrentMemoryBlock().closeForNewEntries();
        this.currentSegment.addMemoryBlock(segmentMemoryBlock);
        this.currentSegment.setCurrentMemoryBlock(segmentMemoryBlock);
        return segmentMemoryBlock;
    }

    public SegmentMemoryBlock startMemoryBlock(String string, SourceRange sourceRange, boolean bl) {
        if (this.isPseudoPcMode) {
            throw new AsmErrorException("You can't start a new memoryblock in pseudo pc mode", sourceRange);
        }
        SegmentMemoryBlock segmentMemoryBlock = new SegmentMemoryBlock(string, bl || this.currentSegment.isVirtual());
        this.currentSegment.getCurrentMemoryBlock().closeForNewEntries();
        this.currentSegment.addMemoryBlock(segmentMemoryBlock);
        this.currentSegment.setCurrentMemoryBlock(segmentMemoryBlock);
        return segmentMemoryBlock;
    }

    public void setMemoryPosition(int n) {
        this.setMemoryPositionWithoutSideEffect(n);
        this.state.sideeffectMgr.addSideEffect(new SESetMemoryPosition(n));
    }

    public void setMemoryPositionWithoutSideEffect(int n) {
        this.currentSegment.setMemoryPosition(n);
    }

    public void increaseMemoryPosition(int n) {
        this.increaseMemoryPositionWithoutSideEffect(n);
        this.state.sideeffectMgr.addSideEffect(new SEIncreaseMemoryPosition(n));
    }

    public void increaseMemoryPositionWithoutSideEffect(int n) {
        this.currentSegment.increaseMemoryPosition(n);
        if (this.pseudoPcPosition >= 0) {
            this.pseudoPcPosition += n;
        }
    }

    public void enterPseudoPcMode(int n, SourceRange sourceRange) {
        if (this.isPseudoPcMode) {
            throw new AsmErrorException("You can't nest pseudo pc directives", sourceRange);
        }
        this.isPseudoPcMode = true;
        this.pseudoPcPosition = n;
    }

    public void exitPseudoPcMode() {
        this.isPseudoPcMode = false;
        this.pseudoPcPosition = -1;
    }

    public boolean isPseudoPcMode() {
        return this.isPseudoPcMode;
    }

    public void initPass() {
        this.currentSegment = this.defaultSegment;
        for (Segment segment : this.segments.values()) {
            segment.initPass();
        }
    }

    public void postPassExecution() {
        this.allSegmentsAreRegistered = true;
        for (Segment segment : this.segments.values()) {
            segment.close(this.state);
        }
    }

    public void postPassesExecution() {
        for (Segment segment : this.segments.values()) {
            segment.finalize(this.state);
        }
    }

    public void doOutputAfterPasses() {
        KickAssemblerParameters kickAssemblerParameters = this.state.parameters;
        Logger logger = this.state.log;
        if (kickAssemblerParameters.showMemoryMap) {
            logger.println();
            logger.println(this.printMemoryBlocks(this.segments.values()));
        }
        if (this.state.diagnosticMgr.hasErrors()) {
            return;
        }
    }

    public String printMemoryBlocks(Collection<Segment> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Memory Map\n");
        stringBuilder.append("----------\n");
        boolean bl = true;
        for (Segment segment : collection) {
            if (segment.isHidden() || segment.isIntermediate() || segment.isDefault() && segment.isEmpty()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("\n");
            }
            stringBuilder.append(segment.getName() + "-segment:\n");
            for (SegmentMemoryBlock segmentMemoryBlock : segment.getInputMemoryBlocks()) {
                stringBuilder.append("  ");
                if (segmentMemoryBlock.isVirtual()) {
                    stringBuilder.append("*");
                }
                stringBuilder.append(StringUtil.toHex(segmentMemoryBlock.getStart()) + "-" + StringUtil.toHex(segmentMemoryBlock.getEnd() - 1) + " " + segmentMemoryBlock.getName() + "\n");
            }
        }
        return stringBuilder.toString();
    }
}

